package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterSubnetGroup(
    clusterSubnetGroupName: Option[String] = None,
    description: Option[String] = None,
    vpcId: Option[String] = None,
    subnetGroupStatus: Option[String] = None,
    subnets: Option[Iterable[zio.aws.redshift.model.Subnet]] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup = {
    import ClusterSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
      .builder()
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly =
    zio.aws.redshift.model.ClusterSubnetGroup.wrap(buildAwsValue())
}
object ClusterSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterSubnetGroup =
      zio.aws.redshift.model.ClusterSubnetGroup(
        clusterSubnetGroupName.map(value => value),
        description.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterSubnetGroupName: Option[String]
    def description: Option[String]
    def vpcId: Option[String]
    def subnetGroupStatus: Option[String]
    def subnets: Option[List[zio.aws.redshift.model.Subnet.ReadOnly]]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
  ) extends zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly {
    override val clusterSubnetGroupName: Option[String] =
      scala.Option(impl.clusterSubnetGroupName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnetGroupStatus: Option[String] =
      scala.Option(impl.subnetGroupStatus()).map(value => value: String)
    override val subnets: Option[List[zio.aws.redshift.model.Subnet.ReadOnly]] =
      scala
        .Option(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Subnet.wrap(item)
          }.toList
        )
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
  ): zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly = new Wrapper(impl)
}
