package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcEndpoint(
    vpcEndpointId: Option[String] = None,
    vpcId: Option[String] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.redshift.model.NetworkInterface]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.VpcEndpoint
      .builder()
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.VpcEndpoint.ReadOnly =
    zio.aws.redshift.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.VpcEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.VpcEndpoint =
      zio.aws.redshift.model.VpcEndpoint(
        vpcEndpointId.map(value => value),
        vpcId.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcEndpointId: Option[String]
    def vpcId: Option[String]
    def networkInterfaces
        : Option[List[zio.aws.redshift.model.NetworkInterface.ReadOnly]]
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.VpcEndpoint
  ) extends zio.aws.redshift.model.VpcEndpoint.ReadOnly {
    override val vpcEndpointId: Option[String] =
      scala.Option(impl.vpcEndpointId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val networkInterfaces
        : Option[List[zio.aws.redshift.model.NetworkInterface.ReadOnly]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.NetworkInterface.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.VpcEndpoint
  ): zio.aws.redshift.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
