package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SnapshotErrorMessage(
    snapshotIdentifier: Option[String] = None,
    snapshotClusterIdentifier: Option[String] = None,
    failureCode: Option[String] = None,
    failureReason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage = {
    import SnapshotErrorMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
      .builder()
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly =
    zio.aws.redshift.model.SnapshotErrorMessage.wrap(buildAwsValue())
}
object SnapshotErrorMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SnapshotErrorMessage =
      zio.aws.redshift.model.SnapshotErrorMessage(
        snapshotIdentifier.map(value => value),
        snapshotClusterIdentifier.map(value => value),
        failureCode.map(value => value),
        failureReason.map(value => value)
      )
    def snapshotIdentifier: Option[String]
    def snapshotClusterIdentifier: Option[String]
    def failureCode: Option[String]
    def failureReason: Option[String]
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
  ) extends zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly {
    override val snapshotIdentifier: Option[String] =
      scala.Option(impl.snapshotIdentifier()).map(value => value: String)
    override val snapshotClusterIdentifier: Option[String] =
      scala.Option(impl.snapshotClusterIdentifier()).map(value => value: String)
    override val failureCode: Option[String] =
      scala.Option(impl.failureCode()).map(value => value: String)
    override val failureReason: Option[String] =
      scala.Option(impl.failureReason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
  ): zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly = new Wrapper(impl)
}
