package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedNodeConfigurationOption(
    sourceReservedNode: Option[zio.aws.redshift.model.ReservedNode] = None,
    targetReservedNodeCount: Option[Integer] = None,
    targetReservedNodeOffering: Option[
      zio.aws.redshift.model.ReservedNodeOffering
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption = {
    import ReservedNodeConfigurationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
      .builder()
      .optionallyWith(sourceReservedNode.map(value => value.buildAwsValue()))(
        _.sourceReservedNode
      )
      .optionallyWith(
        targetReservedNodeCount.map(value => value: java.lang.Integer)
      )(_.targetReservedNodeCount)
      .optionallyWith(
        targetReservedNodeOffering.map(value => value.buildAwsValue())
      )(_.targetReservedNodeOffering)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly =
    zio.aws.redshift.model.ReservedNodeConfigurationOption.wrap(buildAwsValue())
}
object ReservedNodeConfigurationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNodeConfigurationOption =
      zio.aws.redshift.model.ReservedNodeConfigurationOption(
        sourceReservedNode.map(value => value.asEditable),
        targetReservedNodeCount.map(value => value),
        targetReservedNodeOffering.map(value => value.asEditable)
      )
    def sourceReservedNode: Option[zio.aws.redshift.model.ReservedNode.ReadOnly]
    def targetReservedNodeCount: Option[Integer]
    def targetReservedNodeOffering
        : Option[zio.aws.redshift.model.ReservedNodeOffering.ReadOnly]
    def getSourceReservedNode
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNode.ReadOnly] =
      AwsError.unwrapOptionField("sourceReservedNode", sourceReservedNode)
    def getTargetReservedNodeCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("targetReservedNodeCount", targetReservedNodeCount)
    def getTargetReservedNodeOffering: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetReservedNodeOffering",
      targetReservedNodeOffering
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
  ) extends zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly {
    override val sourceReservedNode
        : Option[zio.aws.redshift.model.ReservedNode.ReadOnly] = scala
      .Option(impl.sourceReservedNode())
      .map(value => zio.aws.redshift.model.ReservedNode.wrap(value))
    override val targetReservedNodeCount: Option[Integer] =
      scala.Option(impl.targetReservedNodeCount()).map(value => value: Integer)
    override val targetReservedNodeOffering
        : Option[zio.aws.redshift.model.ReservedNodeOffering.ReadOnly] = scala
      .Option(impl.targetReservedNodeOffering())
      .map(value => zio.aws.redshift.model.ReservedNodeOffering.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
  ): zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly =
    new Wrapper(impl)
}
