package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeDataShareResponse(
    dataShareArn: Option[String] = None,
    producerArn: Option[String] = None,
    allowPubliclyAccessibleConsumers: Option[Boolean] = None,
    dataShareAssociations: Option[
      Iterable[zio.aws.redshift.model.DataShareAssociation]
    ] = None,
    managedBy: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse = {
    import AuthorizeDataShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse
      .builder()
      .optionallyWith(dataShareArn.map(value => value: java.lang.String))(
        _.dataShareArn
      )
      .optionallyWith(producerArn.map(value => value: java.lang.String))(
        _.producerArn
      )
      .optionallyWith(
        allowPubliclyAccessibleConsumers.map(value => value: java.lang.Boolean)
      )(_.allowPubliclyAccessibleConsumers)
      .optionallyWith(
        dataShareAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataShareAssociations)
      .optionallyWith(managedBy.map(value => value: java.lang.String))(
        _.managedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly =
    zio.aws.redshift.model.AuthorizeDataShareResponse.wrap(buildAwsValue())
}
object AuthorizeDataShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthorizeDataShareResponse =
      zio.aws.redshift.model.AuthorizeDataShareResponse(
        dataShareArn.map(value => value),
        producerArn.map(value => value),
        allowPubliclyAccessibleConsumers.map(value => value),
        dataShareAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedBy.map(value => value)
      )
    def dataShareArn: Option[String]
    def producerArn: Option[String]
    def allowPubliclyAccessibleConsumers: Option[Boolean]
    def dataShareAssociations
        : Option[List[zio.aws.redshift.model.DataShareAssociation.ReadOnly]]
    def managedBy: Option[String]
    def getDataShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataShareArn", dataShareArn)
    def getProducerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("producerArn", producerArn)
    def getAllowPubliclyAccessibleConsumers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "allowPubliclyAccessibleConsumers",
        allowPubliclyAccessibleConsumers
      )
    def getDataShareAssociations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.DataShareAssociation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("dataShareAssociations", dataShareAssociations)
    def getManagedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("managedBy", managedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse
  ) extends zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly {
    override val dataShareArn: Option[String] =
      scala.Option(impl.dataShareArn()).map(value => value: String)
    override val producerArn: Option[String] =
      scala.Option(impl.producerArn()).map(value => value: String)
    override val allowPubliclyAccessibleConsumers: Option[Boolean] = scala
      .Option(impl.allowPubliclyAccessibleConsumers())
      .map(value => value: Boolean)
    override val dataShareAssociations
        : Option[List[zio.aws.redshift.model.DataShareAssociation.ReadOnly]] =
      scala
        .Option(impl.dataShareAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.DataShareAssociation.wrap(item)
          }.toList
        )
    override val managedBy: Option[String] =
      scala.Option(impl.managedBy()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse
  ): zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly = new Wrapper(
    impl
  )
}
