package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeOrderableClusterOptionsResponse(
    orderableClusterOptions: Option[
      Iterable[zio.aws.redshift.model.OrderableClusterOption]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse = {
    import DescribeOrderableClusterOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse
      .builder()
      .optionallyWith(
        orderableClusterOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderableClusterOptions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeOrderableClusterOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse =
      zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse(
        orderableClusterOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def orderableClusterOptions
        : Option[List[zio.aws.redshift.model.OrderableClusterOption.ReadOnly]]
    def marker: Option[String]
    def getOrderableClusterOptions: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.OrderableClusterOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "orderableClusterOptions",
      orderableClusterOptions
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse
  ) extends zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly {
    override val orderableClusterOptions
        : Option[List[zio.aws.redshift.model.OrderableClusterOption.ReadOnly]] =
      scala
        .Option(impl.orderableClusterOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.OrderableClusterOption.wrap(item)
          }.toList
        )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse
  ): zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
