package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DataShareAssociation(
    consumerIdentifier: Option[String] = None,
    status: Option[zio.aws.redshift.model.DataShareStatus] = None,
    consumerRegion: Option[String] = None,
    createdDate: Option[TStamp] = None,
    statusChangeDate: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DataShareAssociation = {
    import DataShareAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DataShareAssociation
      .builder()
      .optionallyWith(consumerIdentifier.map(value => value: java.lang.String))(
        _.consumerIdentifier
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(consumerRegion.map(value => value: java.lang.String))(
        _.consumerRegion
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        statusChangeDate.map(value => TStamp.unwrap(value): Instant)
      )(_.statusChangeDate)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DataShareAssociation.ReadOnly =
    zio.aws.redshift.model.DataShareAssociation.wrap(buildAwsValue())
}
object DataShareAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DataShareAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DataShareAssociation =
      zio.aws.redshift.model.DataShareAssociation(
        consumerIdentifier.map(value => value),
        status.map(value => value),
        consumerRegion.map(value => value),
        createdDate.map(value => value),
        statusChangeDate.map(value => value)
      )
    def consumerIdentifier: Option[String]
    def status: Option[zio.aws.redshift.model.DataShareStatus]
    def consumerRegion: Option[String]
    def createdDate: Option[TStamp]
    def statusChangeDate: Option[TStamp]
    def getConsumerIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerIdentifier", consumerIdentifier)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshift.model.DataShareStatus] =
      AwsError.unwrapOptionField("status", status)
    def getConsumerRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerRegion", consumerRegion)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getStatusChangeDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("statusChangeDate", statusChangeDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DataShareAssociation
  ) extends zio.aws.redshift.model.DataShareAssociation.ReadOnly {
    override val consumerIdentifier: Option[String] =
      scala.Option(impl.consumerIdentifier()).map(value => value: String)
    override val status: Option[zio.aws.redshift.model.DataShareStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.redshift.model.DataShareStatus.wrap(value))
    override val consumerRegion: Option[String] =
      scala.Option(impl.consumerRegion()).map(value => value: String)
    override val createdDate: Option[TStamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val statusChangeDate: Option[TStamp] = scala
      .Option(impl.statusChangeDate())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DataShareAssociation
  ): zio.aws.redshift.model.DataShareAssociation.ReadOnly = new Wrapper(impl)
}
