package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClusterRequest(
    clusterIdentifier: String,
    clusterType: Option[String] = None,
    nodeType: Option[String] = None,
    numberOfNodes: Option[IntegerOptional] = None,
    clusterSecurityGroups: Option[Iterable[String]] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    masterUserPassword: Option[String] = None,
    clusterParameterGroupName: Option[String] = None,
    automatedSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    manualSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    preferredMaintenanceWindow: Option[String] = None,
    clusterVersion: Option[String] = None,
    allowVersionUpgrade: Option[BooleanOptional] = None,
    hsmClientCertificateIdentifier: Option[String] = None,
    hsmConfigurationIdentifier: Option[String] = None,
    newClusterIdentifier: Option[String] = None,
    publiclyAccessible: Option[BooleanOptional] = None,
    elasticIp: Option[String] = None,
    enhancedVpcRouting: Option[BooleanOptional] = None,
    maintenanceTrackName: Option[String] = None,
    encrypted: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    availabilityZoneRelocation: Option[BooleanOptional] = None,
    availabilityZone: Option[String] = None,
    port: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterRequest = {
    import ModifyClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        clusterParameterGroupName.map(value => value: java.lang.String)
      )(_.clusterParameterGroupName)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(
        newClusterIdentifier.map(value => value: java.lang.String)
      )(_.newClusterIdentifier)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        availabilityZoneRelocation.map(value => value: java.lang.Boolean)
      )(_.availabilityZoneRelocation)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyClusterRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterRequest.wrap(buildAwsValue())
}
object ModifyClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterRequest =
      zio.aws.redshift.model.ModifyClusterRequest(
        clusterIdentifier,
        clusterType.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        clusterSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        masterUserPassword.map(value => value),
        clusterParameterGroupName.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        clusterVersion.map(value => value),
        allowVersionUpgrade.map(value => value),
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        newClusterIdentifier.map(value => value),
        publiclyAccessible.map(value => value),
        elasticIp.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        availabilityZoneRelocation.map(value => value),
        availabilityZone.map(value => value),
        port.map(value => value)
      )
    def clusterIdentifier: String
    def clusterType: Option[String]
    def nodeType: Option[String]
    def numberOfNodes: Option[IntegerOptional]
    def clusterSecurityGroups: Option[List[String]]
    def vpcSecurityGroupIds: Option[List[String]]
    def masterUserPassword: Option[String]
    def clusterParameterGroupName: Option[String]
    def automatedSnapshotRetentionPeriod: Option[IntegerOptional]
    def manualSnapshotRetentionPeriod: Option[IntegerOptional]
    def preferredMaintenanceWindow: Option[String]
    def clusterVersion: Option[String]
    def allowVersionUpgrade: Option[BooleanOptional]
    def hsmClientCertificateIdentifier: Option[String]
    def hsmConfigurationIdentifier: Option[String]
    def newClusterIdentifier: Option[String]
    def publiclyAccessible: Option[BooleanOptional]
    def elasticIp: Option[String]
    def enhancedVpcRouting: Option[BooleanOptional]
    def maintenanceTrackName: Option[String]
    def encrypted: Option[BooleanOptional]
    def kmsKeyId: Option[String]
    def availabilityZoneRelocation: Option[BooleanOptional]
    def availabilityZone: Option[String]
    def port: Option[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getClusterParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterParameterGroupName", clusterParameterGroupName)
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getNewClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newClusterIdentifier", newClusterIdentifier)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAvailabilityZoneRelocation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocation",
        availabilityZoneRelocation
      )
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
  ) extends zio.aws.redshift.model.ModifyClusterRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val clusterType: Option[String] =
      scala.Option(impl.clusterType()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val numberOfNodes: Option[IntegerOptional] =
      scala.Option(impl.numberOfNodes()).map(value => value: IntegerOptional)
    override val clusterSecurityGroups: Option[List[String]] = scala
      .Option(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val masterUserPassword: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val clusterParameterGroupName: Option[String] =
      scala.Option(impl.clusterParameterGroupName()).map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Option[IntegerOptional] =
      scala
        .Option(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val manualSnapshotRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val allowVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.allowVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val hsmClientCertificateIdentifier: Option[String] = scala
      .Option(impl.hsmClientCertificateIdentifier())
      .map(value => value: String)
    override val hsmConfigurationIdentifier: Option[String] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => value: String)
    override val newClusterIdentifier: Option[String] =
      scala.Option(impl.newClusterIdentifier()).map(value => value: String)
    override val publiclyAccessible: Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
    override val elasticIp: Option[String] =
      scala.Option(impl.elasticIp()).map(value => value: String)
    override val enhancedVpcRouting: Option[BooleanOptional] = scala
      .Option(impl.enhancedVpcRouting())
      .map(value => value: BooleanOptional)
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val encrypted: Option[BooleanOptional] =
      scala.Option(impl.encrypted()).map(value => value: BooleanOptional)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val availabilityZoneRelocation: Option[BooleanOptional] = scala
      .Option(impl.availabilityZoneRelocation())
      .map(value => value: BooleanOptional)
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
  ): zio.aws.redshift.model.ModifyClusterRequest.ReadOnly = new Wrapper(impl)
}
