package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeOrderableClusterOptionsRequest(
    clusterVersion: Option[String] = None,
    nodeType: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest = {
    import DescribeOrderableClusterOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeOrderableClusterOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest =
      zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest(
        clusterVersion.map(value => value),
        nodeType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterVersion: Option[String]
    def nodeType: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
  ) extends zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest.ReadOnly {
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
  ): zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
