package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateEndpointAccessResponse(
    clusterIdentifier: Option[String] = None,
    resourceOwner: Option[String] = None,
    subnetGroupName: Option[String] = None,
    endpointStatus: Option[String] = None,
    endpointName: Option[String] = None,
    endpointCreateTime: Option[TStamp] = None,
    port: Option[Integer] = None,
    address: Option[String] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.redshift.model.VpcSecurityGroupMembership]
    ] = None,
    vpcEndpoint: Option[zio.aws.redshift.model.VpcEndpoint] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse = {
    import CreateEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(endpointStatus.map(value => value: java.lang.String))(
        _.endpointStatus
      )
      .optionallyWith(endpointName.map(value => value: java.lang.String))(
        _.endpointName
      )
      .optionallyWith(
        endpointCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.endpointCreateTime)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly =
    zio.aws.redshift.model.CreateEndpointAccessResponse.wrap(buildAwsValue())
}
object CreateEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateEndpointAccessResponse =
      zio.aws.redshift.model.CreateEndpointAccessResponse(
        clusterIdentifier.map(value => value),
        resourceOwner.map(value => value),
        subnetGroupName.map(value => value),
        endpointStatus.map(value => value),
        endpointName.map(value => value),
        endpointCreateTime.map(value => value),
        port.map(value => value),
        address.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpoint.map(value => value.asEditable)
      )
    def clusterIdentifier: Option[String]
    def resourceOwner: Option[String]
    def subnetGroupName: Option[String]
    def endpointStatus: Option[String]
    def endpointName: Option[String]
    def endpointCreateTime: Option[TStamp]
    def port: Option[Integer]
    def address: Option[String]
    def vpcSecurityGroups: Option[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def vpcEndpoint: Option[zio.aws.redshift.model.VpcEndpoint.ReadOnly]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getEndpointStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointStatus", endpointStatus)
    def getEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getEndpointCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endpointCreateTime", endpointCreateTime)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getVpcEndpoint
        : ZIO[Any, AwsError, zio.aws.redshift.model.VpcEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse
  ) extends zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val resourceOwner: Option[String] =
      scala.Option(impl.resourceOwner()).map(value => value: String)
    override val subnetGroupName: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override val endpointStatus: Option[String] =
      scala.Option(impl.endpointStatus()).map(value => value: String)
    override val endpointName: Option[String] =
      scala.Option(impl.endpointName()).map(value => value: String)
    override val endpointCreateTime: Option[TStamp] = scala
      .Option(impl.endpointCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val address: Option[String] =
      scala.Option(impl.address()).map(value => value: String)
    override val vpcSecurityGroups: Option[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcEndpoint
        : Option[zio.aws.redshift.model.VpcEndpoint.ReadOnly] = scala
      .Option(impl.vpcEndpoint())
      .map(value => zio.aws.redshift.model.VpcEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse
  ): zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
