package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RevisionTarget(
    databaseRevision: Option[String] = None,
    description: Option[String] = None,
    databaseRevisionReleaseDate: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevisionTarget = {
    import RevisionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevisionTarget
      .builder()
      .optionallyWith(databaseRevision.map(value => value: java.lang.String))(
        _.databaseRevision
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        databaseRevisionReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.databaseRevisionReleaseDate)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevisionTarget.ReadOnly =
    zio.aws.redshift.model.RevisionTarget.wrap(buildAwsValue())
}
object RevisionTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevisionTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevisionTarget =
      zio.aws.redshift.model.RevisionTarget(
        databaseRevision.map(value => value),
        description.map(value => value),
        databaseRevisionReleaseDate.map(value => value)
      )
    def databaseRevision: Option[String]
    def description: Option[String]
    def databaseRevisionReleaseDate: Option[TStamp]
    def getDatabaseRevision: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseRevision", databaseRevision)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDatabaseRevisionReleaseDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "databaseRevisionReleaseDate",
        databaseRevisionReleaseDate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevisionTarget
  ) extends zio.aws.redshift.model.RevisionTarget.ReadOnly {
    override val databaseRevision: Option[String] =
      scala.Option(impl.databaseRevision()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val databaseRevisionReleaseDate: Option[TStamp] = scala
      .Option(impl.databaseRevisionReleaseDate())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevisionTarget
  ): zio.aws.redshift.model.RevisionTarget.ReadOnly = new Wrapper(impl)
}
