package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  TStamp,
  PartnerIntegrationStatusMessage,
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PartnerIntegrationInfo(
    databaseName: Option[PartnerIntegrationDatabaseName] = None,
    partnerName: Option[PartnerIntegrationPartnerName] = None,
    status: Option[zio.aws.redshift.model.PartnerIntegrationStatus] = None,
    statusMessage: Option[PartnerIntegrationStatusMessage] = None,
    createdAt: Option[TStamp] = None,
    updatedAt: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo = {
    import PartnerIntegrationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
      .builder()
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          PartnerIntegrationStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => TStamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly =
    zio.aws.redshift.model.PartnerIntegrationInfo.wrap(buildAwsValue())
}
object PartnerIntegrationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PartnerIntegrationInfo =
      zio.aws.redshift.model.PartnerIntegrationInfo(
        databaseName.map(value => value),
        partnerName.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def databaseName: Option[PartnerIntegrationDatabaseName]
    def partnerName: Option[PartnerIntegrationPartnerName]
    def status: Option[zio.aws.redshift.model.PartnerIntegrationStatus]
    def statusMessage: Option[PartnerIntegrationStatusMessage]
    def createdAt: Option[TStamp]
    def updatedAt: Option[TStamp]
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.PartnerIntegrationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, PartnerIntegrationStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
  ) extends zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly {
    override val databaseName: Option[PartnerIntegrationDatabaseName] = scala
      .Option(impl.databaseName())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationDatabaseName(value)
      )
    override val partnerName: Option[PartnerIntegrationPartnerName] = scala
      .Option(impl.partnerName())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
      )
    override val status
        : Option[zio.aws.redshift.model.PartnerIntegrationStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.redshift.model.PartnerIntegrationStatus.wrap(value))
    override val statusMessage: Option[PartnerIntegrationStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationStatusMessage(value)
      )
    override val createdAt: Option[TStamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val updatedAt: Option[TStamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
  ): zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly = new Wrapper(impl)
}
