package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{
  LongOptional,
  DoubleOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeResizeResponse(
    targetNodeType: Option[String] = None,
    targetNumberOfNodes: Option[IntegerOptional] = None,
    targetClusterType: Option[String] = None,
    status: Option[String] = None,
    importTablesCompleted: Option[Iterable[String]] = None,
    importTablesInProgress: Option[Iterable[String]] = None,
    importTablesNotStarted: Option[Iterable[String]] = None,
    avgResizeRateInMegaBytesPerSecond: Option[DoubleOptional] = None,
    totalResizeDataInMegaBytes: Option[LongOptional] = None,
    progressInMegaBytes: Option[LongOptional] = None,
    elapsedTimeInSeconds: Option[LongOptional] = None,
    estimatedTimeToCompletionInSeconds: Option[LongOptional] = None,
    resizeType: Option[String] = None,
    message: Option[String] = None,
    targetEncryptionType: Option[String] = None,
    dataTransferProgressPercent: Option[DoubleOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeResizeResponse = {
    import DescribeResizeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
      .builder()
      .optionallyWith(targetNodeType.map(value => value: java.lang.String))(
        _.targetNodeType
      )
      .optionallyWith(targetNumberOfNodes.map(value => value: Integer))(
        _.targetNumberOfNodes
      )
      .optionallyWith(targetClusterType.map(value => value: java.lang.String))(
        _.targetClusterType
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        importTablesCompleted.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importTablesCompleted)
      .optionallyWith(
        importTablesInProgress.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importTablesInProgress)
      .optionallyWith(
        importTablesNotStarted.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importTablesNotStarted)
      .optionallyWith(
        avgResizeRateInMegaBytesPerSecond.map(value => value: java.lang.Double)
      )(_.avgResizeRateInMegaBytesPerSecond)
      .optionallyWith(
        totalResizeDataInMegaBytes.map(value => value: java.lang.Long)
      )(_.totalResizeDataInMegaBytes)
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(
        estimatedTimeToCompletionInSeconds.map(value => value: java.lang.Long)
      )(_.estimatedTimeToCompletionInSeconds)
      .optionallyWith(resizeType.map(value => value: java.lang.String))(
        _.resizeType
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        targetEncryptionType.map(value => value: java.lang.String)
      )(_.targetEncryptionType)
      .optionallyWith(
        dataTransferProgressPercent.map(value => value: java.lang.Double)
      )(_.dataTransferProgressPercent)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeResizeResponse.ReadOnly =
    zio.aws.redshift.model.DescribeResizeResponse.wrap(buildAwsValue())
}
object DescribeResizeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeResizeResponse =
      zio.aws.redshift.model.DescribeResizeResponse(
        targetNodeType.map(value => value),
        targetNumberOfNodes.map(value => value),
        targetClusterType.map(value => value),
        status.map(value => value),
        importTablesCompleted.map(value => value),
        importTablesInProgress.map(value => value),
        importTablesNotStarted.map(value => value),
        avgResizeRateInMegaBytesPerSecond.map(value => value),
        totalResizeDataInMegaBytes.map(value => value),
        progressInMegaBytes.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        estimatedTimeToCompletionInSeconds.map(value => value),
        resizeType.map(value => value),
        message.map(value => value),
        targetEncryptionType.map(value => value),
        dataTransferProgressPercent.map(value => value)
      )
    def targetNodeType: Option[String]
    def targetNumberOfNodes: Option[IntegerOptional]
    def targetClusterType: Option[String]
    def status: Option[String]
    def importTablesCompleted: Option[List[String]]
    def importTablesInProgress: Option[List[String]]
    def importTablesNotStarted: Option[List[String]]
    def avgResizeRateInMegaBytesPerSecond: Option[DoubleOptional]
    def totalResizeDataInMegaBytes: Option[LongOptional]
    def progressInMegaBytes: Option[LongOptional]
    def elapsedTimeInSeconds: Option[LongOptional]
    def estimatedTimeToCompletionInSeconds: Option[LongOptional]
    def resizeType: Option[String]
    def message: Option[String]
    def targetEncryptionType: Option[String]
    def dataTransferProgressPercent: Option[DoubleOptional]
    def getTargetNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetNodeType", targetNodeType)
    def getTargetNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("targetNumberOfNodes", targetNumberOfNodes)
    def getTargetClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetClusterType", targetClusterType)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getImportTablesCompleted: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("importTablesCompleted", importTablesCompleted)
    def getImportTablesInProgress: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("importTablesInProgress", importTablesInProgress)
    def getImportTablesNotStarted: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("importTablesNotStarted", importTablesNotStarted)
    def getAvgResizeRateInMegaBytesPerSecond
        : ZIO[Any, AwsError, DoubleOptional] = AwsError.unwrapOptionField(
      "avgResizeRateInMegaBytesPerSecond",
      avgResizeRateInMegaBytesPerSecond
    )
    def getTotalResizeDataInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField(
        "totalResizeDataInMegaBytes",
        totalResizeDataInMegaBytes
      )
    def getProgressInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getEstimatedTimeToCompletionInSeconds
        : ZIO[Any, AwsError, LongOptional] = AwsError.unwrapOptionField(
      "estimatedTimeToCompletionInSeconds",
      estimatedTimeToCompletionInSeconds
    )
    def getResizeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resizeType", resizeType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getTargetEncryptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEncryptionType", targetEncryptionType)
    def getDataTransferProgressPercent: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField(
        "dataTransferProgressPercent",
        dataTransferProgressPercent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
  ) extends zio.aws.redshift.model.DescribeResizeResponse.ReadOnly {
    override val targetNodeType: Option[String] =
      scala.Option(impl.targetNodeType()).map(value => value: String)
    override val targetNumberOfNodes: Option[IntegerOptional] = scala
      .Option(impl.targetNumberOfNodes())
      .map(value => value: IntegerOptional)
    override val targetClusterType: Option[String] =
      scala.Option(impl.targetClusterType()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val importTablesCompleted: Option[List[String]] = scala
      .Option(impl.importTablesCompleted())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val importTablesInProgress: Option[List[String]] = scala
      .Option(impl.importTablesInProgress())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val importTablesNotStarted: Option[List[String]] = scala
      .Option(impl.importTablesNotStarted())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val avgResizeRateInMegaBytesPerSecond: Option[DoubleOptional] =
      scala
        .Option(impl.avgResizeRateInMegaBytesPerSecond())
        .map(value => value: DoubleOptional)
    override val totalResizeDataInMegaBytes: Option[LongOptional] = scala
      .Option(impl.totalResizeDataInMegaBytes())
      .map(value => value: LongOptional)
    override val progressInMegaBytes: Option[LongOptional] =
      scala.Option(impl.progressInMegaBytes()).map(value => value: LongOptional)
    override val elapsedTimeInSeconds: Option[LongOptional] = scala
      .Option(impl.elapsedTimeInSeconds())
      .map(value => value: LongOptional)
    override val estimatedTimeToCompletionInSeconds: Option[LongOptional] =
      scala
        .Option(impl.estimatedTimeToCompletionInSeconds())
        .map(value => value: LongOptional)
    override val resizeType: Option[String] =
      scala.Option(impl.resizeType()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val targetEncryptionType: Option[String] =
      scala.Option(impl.targetEncryptionType()).map(value => value: String)
    override val dataTransferProgressPercent: Option[DoubleOptional] = scala
      .Option(impl.dataTransferProgressPercent())
      .map(value => value: DoubleOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
  ): zio.aws.redshift.model.DescribeResizeResponse.ReadOnly = new Wrapper(impl)
}
