package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHsmClientCertificatesRequest(
    hsmClientCertificateIdentifier: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest = {
    import DescribeHsmClientCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
      .builder()
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeHsmClientCertificatesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeHsmClientCertificatesRequest
      .wrap(buildAwsValue())
}
object DescribeHsmClientCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeHsmClientCertificatesRequest =
      zio.aws.redshift.model.DescribeHsmClientCertificatesRequest(
        hsmClientCertificateIdentifier.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def hsmClientCertificateIdentifier: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
  ) extends zio.aws.redshift.model.DescribeHsmClientCertificatesRequest.ReadOnly {
    override val hsmClientCertificateIdentifier: Option[String] = scala
      .Option(impl.hsmClientCertificateIdentifier())
      .map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
  ): zio.aws.redshift.model.DescribeHsmClientCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
