package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedNodeOffering(
    reservedNodeOfferingId: Option[String] = None,
    nodeType: Option[String] = None,
    duration: Option[Integer] = None,
    fixedPrice: Option[Double] = None,
    usagePrice: Option[Double] = None,
    currencyCode: Option[String] = None,
    offeringType: Option[String] = None,
    recurringCharges: Option[Iterable[zio.aws.redshift.model.RecurringCharge]] =
      None,
    reservedNodeOfferingType: Option[
      zio.aws.redshift.model.ReservedNodeOfferingType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNodeOffering = {
    import ReservedNodeOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
      .builder()
      .optionallyWith(
        reservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodeOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(reservedNodeOfferingType.map(value => value.unwrap))(
        _.reservedNodeOfferingType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ReservedNodeOffering.ReadOnly =
    zio.aws.redshift.model.ReservedNodeOffering.wrap(buildAwsValue())
}
object ReservedNodeOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNodeOffering =
      zio.aws.redshift.model.ReservedNodeOffering(
        reservedNodeOfferingId.map(value => value),
        nodeType.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedNodeOfferingType.map(value => value)
      )
    def reservedNodeOfferingId: Option[String]
    def nodeType: Option[String]
    def duration: Option[Integer]
    def fixedPrice: Option[Double]
    def usagePrice: Option[Double]
    def currencyCode: Option[String]
    def offeringType: Option[String]
    def recurringCharges
        : Option[List[zio.aws.redshift.model.RecurringCharge.ReadOnly]]
    def reservedNodeOfferingType
        : Option[zio.aws.redshift.model.ReservedNodeOfferingType]
    def getReservedNodeOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodeOfferingId", reservedNodeOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservedNodeOfferingType
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNodeOfferingType] =
      AwsError.unwrapOptionField(
        "reservedNodeOfferingType",
        reservedNodeOfferingType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
  ) extends zio.aws.redshift.model.ReservedNodeOffering.ReadOnly {
    override val reservedNodeOfferingId: Option[String] =
      scala.Option(impl.reservedNodeOfferingId()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val duration: Option[Integer] =
      scala.Option(impl.duration()).map(value => value: Integer)
    override val fixedPrice: Option[Double] =
      scala.Option(impl.fixedPrice()).map(value => value: Double)
    override val usagePrice: Option[Double] =
      scala.Option(impl.usagePrice()).map(value => value: Double)
    override val currencyCode: Option[String] =
      scala.Option(impl.currencyCode()).map(value => value: String)
    override val offeringType: Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val recurringCharges
        : Option[List[zio.aws.redshift.model.RecurringCharge.ReadOnly]] = scala
      .Option(impl.recurringCharges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.RecurringCharge.wrap(item)
        }.toList
      )
    override val reservedNodeOfferingType
        : Option[zio.aws.redshift.model.ReservedNodeOfferingType] = scala
      .Option(impl.reservedNodeOfferingType())
      .map(value => zio.aws.redshift.model.ReservedNodeOfferingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
  ): zio.aws.redshift.model.ReservedNodeOffering.ReadOnly = new Wrapper(impl)
}
