package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEndpointAuthorizationResponse(
    endpointAuthorizationList: Option[
      Iterable[zio.aws.redshift.model.EndpointAuthorization]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse = {
    import DescribeEndpointAuthorizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse
      .builder()
      .optionallyWith(
        endpointAuthorizationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointAuthorizationList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly =
    zio.aws.redshift.model.DescribeEndpointAuthorizationResponse
      .wrap(buildAwsValue())
}
object DescribeEndpointAuthorizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeEndpointAuthorizationResponse =
      zio.aws.redshift.model.DescribeEndpointAuthorizationResponse(
        endpointAuthorizationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def endpointAuthorizationList
        : Option[List[zio.aws.redshift.model.EndpointAuthorization.ReadOnly]]
    def marker: Option[String]
    def getEndpointAuthorizationList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.EndpointAuthorization.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "endpointAuthorizationList",
      endpointAuthorizationList
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse
  ) extends zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly {
    override val endpointAuthorizationList
        : Option[List[zio.aws.redshift.model.EndpointAuthorization.ReadOnly]] =
      scala
        .Option(impl.endpointAuthorizationList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.EndpointAuthorization.wrap(item)
          }.toList
        )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse
  ): zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly =
    new Wrapper(impl)
}
