package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTagsRequest(
    resourceName: Option[String] = None,
    resourceType: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeTagsRequest = {
    import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeTagsRequest
      .builder()
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeTagsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeTagsRequest.wrap(buildAwsValue())
}
object DescribeTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeTagsRequest =
      zio.aws.redshift.model.DescribeTagsRequest(
        resourceName.map(value => value),
        resourceType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def resourceName: Option[String]
    def resourceType: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTagsRequest
  ) extends zio.aws.redshift.model.DescribeTagsRequest.ReadOnly {
    override val resourceName: Option[String] =
      scala.Option(impl.resourceName()).map(value => value: String)
    override val resourceType: Option[String] =
      scala.Option(impl.resourceType()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTagsRequest
  ): zio.aws.redshift.model.DescribeTagsRequest.ReadOnly = new Wrapper(impl)
}
