package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchModifyClusterSnapshotsResponse(
    resources: Option[Iterable[String]] = None,
    errors: Option[Iterable[zio.aws.redshift.model.SnapshotErrorMessage]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse = {
    import BatchModifyClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly =
    zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse
      .wrap(buildAwsValue())
}
object BatchModifyClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse =
      zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse(
        resources.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resources: Option[List[String]]
    def errors
        : Option[List[zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly]]
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse
  ) extends zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly {
    override val resources: Option[List[String]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val errors
        : Option[List[zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly]] =
      scala
        .Option(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SnapshotErrorMessage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse
  ): zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
