package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RevokeClusterSecurityGroupIngressResponse(
    clusterSecurityGroup: Option[zio.aws.redshift.model.ClusterSecurityGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse = {
    import RevokeClusterSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
      .builder()
      .optionallyWith(clusterSecurityGroup.map(value => value.buildAwsValue()))(
        _.clusterSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly =
    zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse
      .wrap(buildAwsValue())
}
object RevokeClusterSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse =
      zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse(
        clusterSecurityGroup.map(value => value.asEditable)
      )
    def clusterSecurityGroup
        : Option[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]
    def getClusterSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSecurityGroup", clusterSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
  ) extends zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly {
    override val clusterSecurityGroup
        : Option[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly] = scala
      .Option(impl.clusterSecurityGroup())
      .map(value => zio.aws.redshift.model.ClusterSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
  ): zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
