package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifySnapshotScheduleRequest(
    scheduleIdentifier: String,
    scheduleDefinitions: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest = {
    import ModifySnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest
      .builder()
      .scheduleIdentifier(scheduleIdentifier: java.lang.String)
      .scheduleDefinitions(scheduleDefinitions.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifySnapshotScheduleRequest.ReadOnly =
    zio.aws.redshift.model.ModifySnapshotScheduleRequest.wrap(buildAwsValue())
}
object ModifySnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifySnapshotScheduleRequest =
      zio.aws.redshift.model
        .ModifySnapshotScheduleRequest(scheduleIdentifier, scheduleDefinitions)
    def scheduleIdentifier: String
    def scheduleDefinitions: List[String]
    def getScheduleIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(scheduleIdentifier)
    def getScheduleDefinitions: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(scheduleDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest
  ) extends zio.aws.redshift.model.ModifySnapshotScheduleRequest.ReadOnly {
    override val scheduleIdentifier: String = impl.scheduleIdentifier(): String
    override val scheduleDefinitions: List[String] = impl
      .scheduleDefinitions()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest
  ): zio.aws.redshift.model.ModifySnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
