package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateDataShareConsumerRequest(
    dataShareArn: String,
    associateEntireAccount: Option[BooleanOptional] = None,
    consumerArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest = {
    import AssociateDataShareConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .optionallyWith(
        associateEntireAccount.map(value => value: java.lang.Boolean)
      )(_.associateEntireAccount)
      .optionallyWith(consumerArn.map(value => value: java.lang.String))(
        _.consumerArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AssociateDataShareConsumerRequest.ReadOnly =
    zio.aws.redshift.model.AssociateDataShareConsumerRequest
      .wrap(buildAwsValue())
}
object AssociateDataShareConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AssociateDataShareConsumerRequest =
      zio.aws.redshift.model.AssociateDataShareConsumerRequest(
        dataShareArn,
        associateEntireAccount.map(value => value),
        consumerArn.map(value => value)
      )
    def dataShareArn: String
    def associateEntireAccount: Option[BooleanOptional]
    def consumerArn: Option[String]
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
    def getAssociateEntireAccount: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "associateEntireAccount",
        associateEntireAccount
      )
    def getConsumerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerArn", consumerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
  ) extends zio.aws.redshift.model.AssociateDataShareConsumerRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
    override val associateEntireAccount: Option[BooleanOptional] = scala
      .Option(impl.associateEntireAccount())
      .map(value => value: BooleanOptional)
    override val consumerArn: Option[String] =
      scala.Option(impl.consumerArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
  ): zio.aws.redshift.model.AssociateDataShareConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
