package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait ScheduleState {
  def unwrap: software.amazon.awssdk.services.redshift.model.ScheduleState
}
object ScheduleState {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ScheduleState
  ): zio.aws.redshift.model.ScheduleState = value match {
    case software.amazon.awssdk.services.redshift.model.ScheduleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ScheduleState.MODIFYING =>
      val r = MODIFYING
      r
    case software.amazon.awssdk.services.redshift.model.ScheduleState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.redshift.model.ScheduleState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduleState =
      software.amazon.awssdk.services.redshift.model.ScheduleState.UNKNOWN_TO_SDK_VERSION
  }
  case object MODIFYING extends zio.aws.redshift.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduleState =
      software.amazon.awssdk.services.redshift.model.ScheduleState.MODIFYING
  }
  case object ACTIVE extends zio.aws.redshift.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduleState =
      software.amazon.awssdk.services.redshift.model.ScheduleState.ACTIVE
  }
  case object FAILED extends zio.aws.redshift.model.ScheduleState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduleState =
      software.amazon.awssdk.services.redshift.model.ScheduleState.FAILED
  }
}
