package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterParameterStatus(
    parameterName: Option[String] = None,
    parameterApplyStatus: Option[String] = None,
    parameterApplyErrorDescription: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterParameterStatus = {
    import ClusterParameterStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        parameterApplyErrorDescription.map(value => value: java.lang.String)
      )(_.parameterApplyErrorDescription)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterParameterStatus.ReadOnly =
    zio.aws.redshift.model.ClusterParameterStatus.wrap(buildAwsValue())
}
object ClusterParameterStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterParameterStatus =
      zio.aws.redshift.model.ClusterParameterStatus(
        parameterName.map(value => value),
        parameterApplyStatus.map(value => value),
        parameterApplyErrorDescription.map(value => value)
      )
    def parameterName: Option[String]
    def parameterApplyStatus: Option[String]
    def parameterApplyErrorDescription: Option[String]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getParameterApplyErrorDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "parameterApplyErrorDescription",
        parameterApplyErrorDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
  ) extends zio.aws.redshift.model.ClusterParameterStatus.ReadOnly {
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterApplyStatus: Option[String] =
      scala.Option(impl.parameterApplyStatus()).map(value => value: String)
    override val parameterApplyErrorDescription: Option[String] = scala
      .Option(impl.parameterApplyErrorDescription())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
  ): zio.aws.redshift.model.ClusterParameterStatus.ReadOnly = new Wrapper(impl)
}
