package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AcceptReservedNodeExchangeResponse(
    exchangedReservedNode: Option[zio.aws.redshift.model.ReservedNode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse = {
    import AcceptReservedNodeExchangeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse
      .builder()
      .optionallyWith(
        exchangedReservedNode.map(value => value.buildAwsValue())
      )(_.exchangedReservedNode)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly =
    zio.aws.redshift.model.AcceptReservedNodeExchangeResponse
      .wrap(buildAwsValue())
}
object AcceptReservedNodeExchangeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AcceptReservedNodeExchangeResponse =
      zio.aws.redshift.model.AcceptReservedNodeExchangeResponse(
        exchangedReservedNode.map(value => value.asEditable)
      )
    def exchangedReservedNode
        : Option[zio.aws.redshift.model.ReservedNode.ReadOnly]
    def getExchangedReservedNode
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNode.ReadOnly] =
      AwsError.unwrapOptionField("exchangedReservedNode", exchangedReservedNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse
  ) extends zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly {
    override val exchangedReservedNode
        : Option[zio.aws.redshift.model.ReservedNode.ReadOnly] = scala
      .Option(impl.exchangedReservedNode())
      .map(value => zio.aws.redshift.model.ReservedNode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse
  ): zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly =
    new Wrapper(impl)
}
