package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait UsageLimitLimitType {
  def unwrap: software.amazon.awssdk.services.redshift.model.UsageLimitLimitType
}
object UsageLimitLimitType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.UsageLimitLimitType
  ): zio.aws.redshift.model.UsageLimitLimitType = value match {
    case software.amazon.awssdk.services.redshift.model.UsageLimitLimitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitLimitType.TIME =>
      val r = time
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitLimitType.DATA_SCANNED =>
      val r = `data-scanned`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.UsageLimitLimitType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitLimitType =
      software.amazon.awssdk.services.redshift.model.UsageLimitLimitType.UNKNOWN_TO_SDK_VERSION
  }
  case object time extends zio.aws.redshift.model.UsageLimitLimitType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitLimitType =
      software.amazon.awssdk.services.redshift.model.UsageLimitLimitType.TIME
  }
  case object `data-scanned`
      extends zio.aws.redshift.model.UsageLimitLimitType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitLimitType =
      software.amazon.awssdk.services.redshift.model.UsageLimitLimitType.DATA_SCANNED
  }
}
