package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdatePartnerStatusResponse(
    databaseName: Option[PartnerIntegrationDatabaseName] = None,
    partnerName: Option[PartnerIntegrationPartnerName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse = {
    import UpdatePartnerStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse
      .builder()
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly =
    zio.aws.redshift.model.UpdatePartnerStatusResponse.wrap(buildAwsValue())
}
object UpdatePartnerStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.UpdatePartnerStatusResponse =
      zio.aws.redshift.model.UpdatePartnerStatusResponse(
        databaseName.map(value => value),
        partnerName.map(value => value)
      )
    def databaseName: Option[PartnerIntegrationDatabaseName]
    def partnerName: Option[PartnerIntegrationPartnerName]
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse
  ) extends zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly {
    override val databaseName: Option[PartnerIntegrationDatabaseName] = scala
      .Option(impl.databaseName())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationDatabaseName(value)
      )
    override val partnerName: Option[PartnerIntegrationPartnerName] = scala
      .Option(impl.partnerName())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse
  ): zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
