package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResizeInfo(
    resizeType: Option[String] = None,
    allowCancelResize: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResizeInfo = {
    import ResizeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResizeInfo
      .builder()
      .optionallyWith(resizeType.map(value => value: java.lang.String))(
        _.resizeType
      )
      .optionallyWith(allowCancelResize.map(value => value: java.lang.Boolean))(
        _.allowCancelResize
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ResizeInfo.ReadOnly =
    zio.aws.redshift.model.ResizeInfo.wrap(buildAwsValue())
}
object ResizeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResizeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResizeInfo =
      zio.aws.redshift.model.ResizeInfo(
        resizeType.map(value => value),
        allowCancelResize.map(value => value)
      )
    def resizeType: Option[String]
    def allowCancelResize: Option[Boolean]
    def getResizeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resizeType", resizeType)
    def getAllowCancelResize: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowCancelResize", allowCancelResize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResizeInfo
  ) extends zio.aws.redshift.model.ResizeInfo.ReadOnly {
    override val resizeType: Option[String] =
      scala.Option(impl.resizeType()).map(value => value: String)
    override val allowCancelResize: Option[Boolean] =
      scala.Option(impl.allowCancelResize()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResizeInfo
  ): zio.aws.redshift.model.ResizeInfo.ReadOnly = new Wrapper(impl)
}
