package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RejectDataShareRequest(dataShareArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RejectDataShareRequest = {
    import RejectDataShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RejectDataShareRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RejectDataShareRequest.ReadOnly =
    zio.aws.redshift.model.RejectDataShareRequest.wrap(buildAwsValue())
}
object RejectDataShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RejectDataShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RejectDataShareRequest =
      zio.aws.redshift.model.RejectDataShareRequest(dataShareArn)
    def dataShareArn: String
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RejectDataShareRequest
  ) extends zio.aws.redshift.model.RejectDataShareRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RejectDataShareRequest
  ): zio.aws.redshift.model.RejectDataShareRequest.ReadOnly = new Wrapper(impl)
}
