package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClusterVersionsRequest(
    clusterVersion: Option[String] = None,
    clusterParameterGroupFamily: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest = {
    import DescribeClusterVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        clusterParameterGroupFamily.map(value => value: java.lang.String)
      )(_.clusterParameterGroupFamily)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterVersionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterVersionsRequest.wrap(buildAwsValue())
}
object DescribeClusterVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterVersionsRequest =
      zio.aws.redshift.model.DescribeClusterVersionsRequest(
        clusterVersion.map(value => value),
        clusterParameterGroupFamily.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterVersion: Option[String]
    def clusterParameterGroupFamily: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getClusterParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "clusterParameterGroupFamily",
        clusterParameterGroupFamily
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
  ) extends zio.aws.redshift.model.DescribeClusterVersionsRequest.ReadOnly {
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val clusterParameterGroupFamily: Option[String] = scala
      .Option(impl.clusterParameterGroupFamily())
      .map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
  ): zio.aws.redshift.model.DescribeClusterVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
