package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClusterParameterGroupsRequest(
    parameterGroupName: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest = {
    import DescribeClusterParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterParameterGroupsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterParameterGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeClusterParameterGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeClusterParameterGroupsRequest =
      zio.aws.redshift.model.DescribeClusterParameterGroupsRequest(
        parameterGroupName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def parameterGroupName: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest
  ) extends zio.aws.redshift.model.DescribeClusterParameterGroupsRequest.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest
  ): zio.aws.redshift.model.DescribeClusterParameterGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
