package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAccountAttributesRequest(
    attributeNames: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest = {
    import DescribeAccountAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
      .builder()
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeNames)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeAccountAttributesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeAccountAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeAccountAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeAccountAttributesRequest =
      zio.aws.redshift.model
        .DescribeAccountAttributesRequest(attributeNames.map(value => value))
    def attributeNames: Option[List[String]]
    def getAttributeNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
  ) extends zio.aws.redshift.model.DescribeAccountAttributesRequest.ReadOnly {
    override val attributeNames: Option[List[String]] = scala
      .Option(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
  ): zio.aws.redshift.model.DescribeAccountAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
