package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseReservedNodeOfferingRequest(
    reservedNodeOfferingId: String,
    nodeCount: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest = {
    import PurchaseReservedNodeOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
      .builder()
      .reservedNodeOfferingId(reservedNodeOfferingId: java.lang.String)
      .optionallyWith(
        nodeCount.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.nodeCount)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest.ReadOnly =
    zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedNodeOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest =
      zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest(
        reservedNodeOfferingId,
        nodeCount.map(value => value)
      )
    def reservedNodeOfferingId: String
    def nodeCount: Option[IntegerOptional]
    def getReservedNodeOfferingId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedNodeOfferingId)
    def getNodeCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("nodeCount", nodeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
  ) extends zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest.ReadOnly {
    override val reservedNodeOfferingId: String =
      impl.reservedNodeOfferingId(): String
    override val nodeCount: Option[IntegerOptional] = scala
      .Option(impl.nodeCount())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
  ): zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
