package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IPRange(
    status: Option[String] = None,
    cidrip: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.IPRange = {
    import IPRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.IPRange
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.IPRange.ReadOnly =
    zio.aws.redshift.model.IPRange.wrap(buildAwsValue())
}
object IPRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.IPRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.IPRange =
      zio.aws.redshift.model.IPRange(
        status.map(value => value),
        cidrip.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[String]
    def cidrip: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCidrip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrip", cidrip)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.IPRange
  ) extends zio.aws.redshift.model.IPRange.ReadOnly {
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val cidrip: Option[String] =
      scala.Option(impl.cidrip()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.IPRange
  ): zio.aws.redshift.model.IPRange.ReadOnly = new Wrapper(impl)
}
