package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetReservedNodeExchangeConfigurationOptionsRequest(
    actionType: zio.aws.redshift.model.ReservedNodeExchangeActionType,
    clusterIdentifier: Option[String] = None,
    snapshotIdentifier: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest = {
    import GetReservedNodeExchangeConfigurationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
      .builder()
      .actionType(actionType.unwrap)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest.ReadOnly =
    zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
      .wrap(buildAwsValue())
}
object GetReservedNodeExchangeConfigurationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest =
      zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest(
        actionType,
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def actionType: zio.aws.redshift.model.ReservedNodeExchangeActionType
    def clusterIdentifier: Option[String]
    def snapshotIdentifier: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getActionType: ZIO[
      Any,
      Nothing,
      zio.aws.redshift.model.ReservedNodeExchangeActionType
    ] = ZIO.succeed(actionType)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
  ) extends zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest.ReadOnly {
    override val actionType
        : zio.aws.redshift.model.ReservedNodeExchangeActionType =
      zio.aws.redshift.model.ReservedNodeExchangeActionType
        .wrap(impl.actionType())
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val snapshotIdentifier: Option[String] =
      scala.Option(impl.snapshotIdentifier()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
  ): zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
