package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHsmConfigurationsRequest(
    hsmConfigurationIdentifier: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest = {
    import DescribeHsmConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest
      .builder()
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeHsmConfigurationsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeHsmConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeHsmConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeHsmConfigurationsRequest =
      zio.aws.redshift.model.DescribeHsmConfigurationsRequest(
        hsmConfigurationIdentifier.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def hsmConfigurationIdentifier: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest
  ) extends zio.aws.redshift.model.DescribeHsmConfigurationsRequest.ReadOnly {
    override val hsmConfigurationIdentifier: Option[String] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest
  ): zio.aws.redshift.model.DescribeHsmConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
