package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterVersion(
    clusterVersion: Option[String] = None,
    clusterParameterGroupFamily: Option[String] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterVersion = {
    import ClusterVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterVersion
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        clusterParameterGroupFamily.map(value => value: java.lang.String)
      )(_.clusterParameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterVersion.ReadOnly =
    zio.aws.redshift.model.ClusterVersion.wrap(buildAwsValue())
}
object ClusterVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterVersion =
      zio.aws.redshift.model.ClusterVersion(
        clusterVersion.map(value => value),
        clusterParameterGroupFamily.map(value => value),
        description.map(value => value)
      )
    def clusterVersion: Option[String]
    def clusterParameterGroupFamily: Option[String]
    def description: Option[String]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getClusterParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "clusterParameterGroupFamily",
        clusterParameterGroupFamily
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterVersion
  ) extends zio.aws.redshift.model.ClusterVersion.ReadOnly {
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val clusterParameterGroupFamily: Option[String] = scala
      .Option(impl.clusterParameterGroupFamily())
      .map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterVersion
  ): zio.aws.redshift.model.ClusterVersion.ReadOnly = new Wrapper(impl)
}
