package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailabilityZone(
    name: Option[String] = None,
    supportedPlatforms: Option[
      Iterable[zio.aws.redshift.model.SupportedPlatform]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AvailabilityZone
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        supportedPlatforms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedPlatforms)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AvailabilityZone.ReadOnly =
    zio.aws.redshift.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AvailabilityZone =
      zio.aws.redshift.model.AvailabilityZone(
        name.map(value => value),
        supportedPlatforms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[String]
    def supportedPlatforms
        : Option[List[zio.aws.redshift.model.SupportedPlatform.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSupportedPlatforms: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SupportedPlatform.ReadOnly
    ]] = AwsError.unwrapOptionField("supportedPlatforms", supportedPlatforms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AvailabilityZone
  ) extends zio.aws.redshift.model.AvailabilityZone.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val supportedPlatforms
        : Option[List[zio.aws.redshift.model.SupportedPlatform.ReadOnly]] =
      scala
        .Option(impl.supportedPlatforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SupportedPlatform.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AvailabilityZone
  ): zio.aws.redshift.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
