package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeSnapshotAccessResponse(
    snapshot: Option[zio.aws.redshift.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse = {
    import AuthorizeSnapshotAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly =
    zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.wrap(buildAwsValue())
}
object AuthorizeSnapshotAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthorizeSnapshotAccessResponse =
      zio.aws.redshift.model.AuthorizeSnapshotAccessResponse(
        snapshot.map(value => value.asEditable)
      )
    def snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse
  ) extends zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly {
    override val snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.redshift.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse
  ): zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly =
    new Wrapper(impl)
}
