package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeletePartnerResponse(
    databaseName: Option[PartnerIntegrationDatabaseName] = None,
    partnerName: Option[PartnerIntegrationPartnerName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeletePartnerResponse = {
    import DeletePartnerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
      .builder()
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeletePartnerResponse.ReadOnly =
    zio.aws.redshift.model.DeletePartnerResponse.wrap(buildAwsValue())
}
object DeletePartnerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeletePartnerResponse =
      zio.aws.redshift.model.DeletePartnerResponse(
        databaseName.map(value => value),
        partnerName.map(value => value)
      )
    def databaseName: Option[PartnerIntegrationDatabaseName]
    def partnerName: Option[PartnerIntegrationPartnerName]
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
  ) extends zio.aws.redshift.model.DeletePartnerResponse.ReadOnly {
    override val databaseName: Option[PartnerIntegrationDatabaseName] = scala
      .Option(impl.databaseName())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationDatabaseName(value)
      )
    override val partnerName: Option[PartnerIntegrationPartnerName] = scala
      .Option(impl.partnerName())
      .map(value =>
        zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
  ): zio.aws.redshift.model.DeletePartnerResponse.ReadOnly = new Wrapper(impl)
}
