package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterParameterGroupStatus(
    parameterGroupName: Option[String] = None,
    parameterApplyStatus: Option[String] = None,
    clusterParameterStatusList: Option[
      Iterable[zio.aws.redshift.model.ClusterParameterStatus]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus = {
    import ClusterParameterGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterStatusList)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly =
    zio.aws.redshift.model.ClusterParameterGroupStatus.wrap(buildAwsValue())
}
object ClusterParameterGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterParameterGroupStatus =
      zio.aws.redshift.model.ClusterParameterGroupStatus(
        parameterGroupName.map(value => value),
        parameterApplyStatus.map(value => value),
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: Option[String]
    def parameterApplyStatus: Option[String]
    def clusterParameterStatusList
        : Option[List[zio.aws.redshift.model.ClusterParameterStatus.ReadOnly]]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getClusterParameterStatusList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterParameterStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterStatusList",
      clusterParameterStatusList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
  ) extends zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val parameterApplyStatus: Option[String] =
      scala.Option(impl.parameterApplyStatus()).map(value => value: String)
    override val clusterParameterStatusList
        : Option[List[zio.aws.redshift.model.ClusterParameterStatus.ReadOnly]] =
      scala
        .Option(impl.clusterParameterStatusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterParameterStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
  ): zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly = new Wrapper(
    impl
  )
}
