package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EC2SecurityGroup(
    status: Option[String] = None,
    ec2SecurityGroupName: Option[String] = None,
    ec2SecurityGroupOwnerId: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EC2SecurityGroup = {
    import EC2SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        ec2SecurityGroupName.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupName)
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupOwnerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EC2SecurityGroup.ReadOnly =
    zio.aws.redshift.model.EC2SecurityGroup.wrap(buildAwsValue())
}
object EC2SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EC2SecurityGroup =
      zio.aws.redshift.model.EC2SecurityGroup(
        status.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[String]
    def ec2SecurityGroupName: Option[String]
    def ec2SecurityGroupOwnerId: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
  ) extends zio.aws.redshift.model.EC2SecurityGroup.ReadOnly {
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val ec2SecurityGroupName: Option[String] =
      scala.Option(impl.ec2SecurityGroupName()).map(value => value: String)
    override val ec2SecurityGroupOwnerId: Option[String] =
      scala.Option(impl.ec2SecurityGroupOwnerId()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
  ): zio.aws.redshift.model.EC2SecurityGroup.ReadOnly = new Wrapper(impl)
}
