package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterSecurityGroupResponse(
    clusterSecurityGroup: Option[zio.aws.redshift.model.ClusterSecurityGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse = {
    import CreateClusterSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
      .builder()
      .optionallyWith(clusterSecurityGroup.map(value => value.buildAwsValue()))(
        _.clusterSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly =
    zio.aws.redshift.model.CreateClusterSecurityGroupResponse
      .wrap(buildAwsValue())
}
object CreateClusterSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSecurityGroupResponse =
      zio.aws.redshift.model.CreateClusterSecurityGroupResponse(
        clusterSecurityGroup.map(value => value.asEditable)
      )
    def clusterSecurityGroup
        : Option[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]
    def getClusterSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSecurityGroup", clusterSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
  ) extends zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly {
    override val clusterSecurityGroup
        : Option[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly] = scala
      .Option(impl.clusterSecurityGroup())
      .map(value => zio.aws.redshift.model.ClusterSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
  ): zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly =
    new Wrapper(impl)
}
