package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreFromClusterSnapshotRequest(
    clusterIdentifier: String,
    snapshotIdentifier: String,
    snapshotClusterIdentifier: Option[String] = None,
    port: Option[IntegerOptional] = None,
    availabilityZone: Option[String] = None,
    allowVersionUpgrade: Option[BooleanOptional] = None,
    clusterSubnetGroupName: Option[String] = None,
    publiclyAccessible: Option[BooleanOptional] = None,
    ownerAccount: Option[String] = None,
    hsmClientCertificateIdentifier: Option[String] = None,
    hsmConfigurationIdentifier: Option[String] = None,
    elasticIp: Option[String] = None,
    clusterParameterGroupName: Option[String] = None,
    clusterSecurityGroups: Option[Iterable[String]] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    automatedSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    manualSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    kmsKeyId: Option[String] = None,
    nodeType: Option[String] = None,
    enhancedVpcRouting: Option[BooleanOptional] = None,
    additionalInfo: Option[String] = None,
    iamRoles: Option[Iterable[String]] = None,
    maintenanceTrackName: Option[String] = None,
    snapshotScheduleIdentifier: Option[String] = None,
    numberOfNodes: Option[IntegerOptional] = None,
    availabilityZoneRelocation: Option[BooleanOptional] = None,
    aquaConfigurationStatus: Option[
      zio.aws.redshift.model.AquaConfigurationStatus
    ] = None,
    defaultIamRoleArn: Option[String] = None,
    reservedNodeId: Option[String] = None,
    targetReservedNodeOfferingId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest = {
    import RestoreFromClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        allowVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.allowVersionUpgrade)
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(
        publiclyAccessible.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.publiclyAccessible)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(
        clusterParameterGroupName.map(value => value: java.lang.String)
      )(_.clusterParameterGroupName)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(
        enhancedVpcRouting.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enhancedVpcRouting)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        snapshotScheduleIdentifier.map(value => value: java.lang.String)
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(
        numberOfNodes.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numberOfNodes)
      .optionallyWith(
        availabilityZoneRelocation.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.availabilityZoneRelocation)
      .optionallyWith(aquaConfigurationStatus.map(value => value.unwrap))(
        _.aquaConfigurationStatus
      )
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        targetReservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.targetReservedNodeOfferingId)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.RestoreFromClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.RestoreFromClusterSnapshotRequest
      .wrap(buildAwsValue())
}
object RestoreFromClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RestoreFromClusterSnapshotRequest =
      zio.aws.redshift.model.RestoreFromClusterSnapshotRequest(
        clusterIdentifier,
        snapshotIdentifier,
        snapshotClusterIdentifier.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        allowVersionUpgrade.map(value => value),
        clusterSubnetGroupName.map(value => value),
        publiclyAccessible.map(value => value),
        ownerAccount.map(value => value),
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        elasticIp.map(value => value),
        clusterParameterGroupName.map(value => value),
        clusterSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        kmsKeyId.map(value => value),
        nodeType.map(value => value),
        enhancedVpcRouting.map(value => value),
        additionalInfo.map(value => value),
        iamRoles.map(value => value),
        maintenanceTrackName.map(value => value),
        snapshotScheduleIdentifier.map(value => value),
        numberOfNodes.map(value => value),
        availabilityZoneRelocation.map(value => value),
        aquaConfigurationStatus.map(value => value),
        defaultIamRoleArn.map(value => value),
        reservedNodeId.map(value => value),
        targetReservedNodeOfferingId.map(value => value)
      )
    def clusterIdentifier: String
    def snapshotIdentifier: String
    def snapshotClusterIdentifier: Option[String]
    def port: Option[IntegerOptional]
    def availabilityZone: Option[String]
    def allowVersionUpgrade: Option[BooleanOptional]
    def clusterSubnetGroupName: Option[String]
    def publiclyAccessible: Option[BooleanOptional]
    def ownerAccount: Option[String]
    def hsmClientCertificateIdentifier: Option[String]
    def hsmConfigurationIdentifier: Option[String]
    def elasticIp: Option[String]
    def clusterParameterGroupName: Option[String]
    def clusterSecurityGroups: Option[List[String]]
    def vpcSecurityGroupIds: Option[List[String]]
    def preferredMaintenanceWindow: Option[String]
    def automatedSnapshotRetentionPeriod: Option[IntegerOptional]
    def manualSnapshotRetentionPeriod: Option[IntegerOptional]
    def kmsKeyId: Option[String]
    def nodeType: Option[String]
    def enhancedVpcRouting: Option[BooleanOptional]
    def additionalInfo: Option[String]
    def iamRoles: Option[List[String]]
    def maintenanceTrackName: Option[String]
    def snapshotScheduleIdentifier: Option[String]
    def numberOfNodes: Option[IntegerOptional]
    def availabilityZoneRelocation: Option[BooleanOptional]
    def aquaConfigurationStatus
        : Option[zio.aws.redshift.model.AquaConfigurationStatus]
    def defaultIamRoleArn: Option[String]
    def reservedNodeId: Option[String]
    def targetReservedNodeOfferingId: Option[String]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getClusterParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterParameterGroupName", clusterParameterGroupName)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getIamRoles: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getAvailabilityZoneRelocation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocation",
        availabilityZoneRelocation
      )
    def getAquaConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AquaConfigurationStatus] =
      AwsError.unwrapOptionField(
        "aquaConfigurationStatus",
        aquaConfigurationStatus
      )
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getTargetReservedNodeOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReservedNodeOfferingId",
        targetReservedNodeOfferingId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
  ) extends zio.aws.redshift.model.RestoreFromClusterSnapshotRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val snapshotClusterIdentifier: Option[String] =
      scala.Option(impl.snapshotClusterIdentifier()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val allowVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.allowVersionUpgrade())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val clusterSubnetGroupName: Option[String] =
      scala.Option(impl.clusterSubnetGroupName()).map(value => value: String)
    override val publiclyAccessible: Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val ownerAccount: Option[String] =
      scala.Option(impl.ownerAccount()).map(value => value: String)
    override val hsmClientCertificateIdentifier: Option[String] = scala
      .Option(impl.hsmClientCertificateIdentifier())
      .map(value => value: String)
    override val hsmConfigurationIdentifier: Option[String] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => value: String)
    override val elasticIp: Option[String] =
      scala.Option(impl.elasticIp()).map(value => value: String)
    override val clusterParameterGroupName: Option[String] =
      scala.Option(impl.clusterParameterGroupName()).map(value => value: String)
    override val clusterSecurityGroups: Option[List[String]] = scala
      .Option(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Option[IntegerOptional] =
      scala
        .Option(impl.automatedSnapshotRetentionPeriod())
        .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val manualSnapshotRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val enhancedVpcRouting: Option[BooleanOptional] = scala
      .Option(impl.enhancedVpcRouting())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val additionalInfo: Option[String] =
      scala.Option(impl.additionalInfo()).map(value => value: String)
    override val iamRoles: Option[List[String]] = scala
      .Option(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val snapshotScheduleIdentifier: Option[String] = scala
      .Option(impl.snapshotScheduleIdentifier())
      .map(value => value: String)
    override val numberOfNodes: Option[IntegerOptional] = scala
      .Option(impl.numberOfNodes())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val availabilityZoneRelocation: Option[BooleanOptional] = scala
      .Option(impl.availabilityZoneRelocation())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val aquaConfigurationStatus
        : Option[zio.aws.redshift.model.AquaConfigurationStatus] = scala
      .Option(impl.aquaConfigurationStatus())
      .map(value => zio.aws.redshift.model.AquaConfigurationStatus.wrap(value))
    override val defaultIamRoleArn: Option[String] =
      scala.Option(impl.defaultIamRoleArn()).map(value => value: String)
    override val reservedNodeId: Option[String] =
      scala.Option(impl.reservedNodeId()).map(value => value: String)
    override val targetReservedNodeOfferingId: Option[String] = scala
      .Option(impl.targetReservedNodeOfferingId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
  ): zio.aws.redshift.model.RestoreFromClusterSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
