package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetReservedNodeExchangeOfferingsRequest(
    reservedNodeId: String,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest = {
    import GetReservedNodeExchangeOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest
      .builder()
      .reservedNodeId(reservedNodeId: java.lang.String)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetReservedNodeExchangeOfferingsRequest.ReadOnly =
    zio.aws.redshift.model.GetReservedNodeExchangeOfferingsRequest
      .wrap(buildAwsValue())
}
object GetReservedNodeExchangeOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.GetReservedNodeExchangeOfferingsRequest =
      zio.aws.redshift.model.GetReservedNodeExchangeOfferingsRequest(
        reservedNodeId,
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedNodeId: String
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getReservedNodeId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedNodeId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest
  ) extends zio.aws.redshift.model.GetReservedNodeExchangeOfferingsRequest.ReadOnly {
    override val reservedNodeId: String = impl.reservedNodeId(): String
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest
  ): zio.aws.redshift.model.GetReservedNodeExchangeOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
