package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EventInfoMap(
    eventId: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None,
    eventDescription: Option[String] = None,
    severity: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EventInfoMap = {
    import EventInfoMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EventInfoMap
      .builder()
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(eventDescription.map(value => value: java.lang.String))(
        _.eventDescription
      )
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EventInfoMap.ReadOnly =
    zio.aws.redshift.model.EventInfoMap.wrap(buildAwsValue())
}
object EventInfoMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EventInfoMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EventInfoMap =
      zio.aws.redshift.model.EventInfoMap(
        eventId.map(value => value),
        eventCategories.map(value => value),
        eventDescription.map(value => value),
        severity.map(value => value)
      )
    def eventId: Option[String]
    def eventCategories: Option[List[String]]
    def eventDescription: Option[String]
    def severity: Option[String]
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getEventDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventDescription", eventDescription)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EventInfoMap
  ) extends zio.aws.redshift.model.EventInfoMap.ReadOnly {
    override val eventId: Option[String] =
      scala.Option(impl.eventId()).map(value => value: String)
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventDescription: Option[String] =
      scala.Option(impl.eventDescription()).map(value => value: String)
    override val severity: Option[String] =
      scala.Option(impl.severity()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EventInfoMap
  ): zio.aws.redshift.model.EventInfoMap.ReadOnly = new Wrapper(impl)
}
