package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{IntegerOptional, BooleanOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotScheduleRequest(
    scheduleDefinitions: Option[Iterable[String]] = None,
    scheduleIdentifier: Option[String] = None,
    scheduleDescription: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None,
    dryRun: Option[BooleanOptional] = None,
    nextInvocations: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest = {
    import CreateSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
      .builder()
      .optionallyWith(
        scheduleDefinitions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scheduleDefinitions)
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        scheduleDescription.map(value => value: java.lang.String)
      )(_.scheduleDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dryRun.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .optionallyWith(
        nextInvocations.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.nextInvocations)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateSnapshotScheduleRequest.ReadOnly =
    zio.aws.redshift.model.CreateSnapshotScheduleRequest.wrap(buildAwsValue())
}
object CreateSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateSnapshotScheduleRequest =
      zio.aws.redshift.model.CreateSnapshotScheduleRequest(
        scheduleDefinitions.map(value => value),
        scheduleIdentifier.map(value => value),
        scheduleDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        nextInvocations.map(value => value)
      )
    def scheduleDefinitions: Option[List[String]]
    def scheduleIdentifier: Option[String]
    def scheduleDescription: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def dryRun: Option[BooleanOptional]
    def nextInvocations: Option[IntegerOptional]
    def getScheduleDefinitions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scheduleDefinitions", scheduleDefinitions)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getScheduleDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleDescription", scheduleDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDryRun: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNextInvocations: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("nextInvocations", nextInvocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
  ) extends zio.aws.redshift.model.CreateSnapshotScheduleRequest.ReadOnly {
    override val scheduleDefinitions: Option[List[String]] = scala
      .Option(impl.scheduleDefinitions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val scheduleIdentifier: Option[String] =
      scala.Option(impl.scheduleIdentifier()).map(value => value: String)
    override val scheduleDescription: Option[String] =
      scala.Option(impl.scheduleDescription()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
    override val dryRun: Option[BooleanOptional] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val nextInvocations: Option[IntegerOptional] = scala
      .Option(impl.nextInvocations())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
  ): zio.aws.redshift.model.CreateSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
