package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnableLoggingResponse(
    loggingEnabled: Option[Boolean] = None,
    bucketName: Option[String] = None,
    s3KeyPrefix: Option[String] = None,
    lastSuccessfulDeliveryTime: Option[TStamp] = None,
    lastFailureTime: Option[TStamp] = None,
    lastFailureMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EnableLoggingResponse = {
    import EnableLoggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EnableLoggingResponse
      .builder()
      .optionallyWith(loggingEnabled.map(value => value: java.lang.Boolean))(
        _.loggingEnabled
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .optionallyWith(
        lastSuccessfulDeliveryTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastSuccessfulDeliveryTime)
      .optionallyWith(
        lastFailureTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastFailureTime)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EnableLoggingResponse.ReadOnly =
    zio.aws.redshift.model.EnableLoggingResponse.wrap(buildAwsValue())
}
object EnableLoggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EnableLoggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EnableLoggingResponse =
      zio.aws.redshift.model.EnableLoggingResponse(
        loggingEnabled.map(value => value),
        bucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        lastSuccessfulDeliveryTime.map(value => value),
        lastFailureTime.map(value => value),
        lastFailureMessage.map(value => value)
      )
    def loggingEnabled: Option[Boolean]
    def bucketName: Option[String]
    def s3KeyPrefix: Option[String]
    def lastSuccessfulDeliveryTime: Option[TStamp]
    def lastFailureTime: Option[TStamp]
    def lastFailureMessage: Option[String]
    def getLoggingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("loggingEnabled", loggingEnabled)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getLastSuccessfulDeliveryTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "lastSuccessfulDeliveryTime",
        lastSuccessfulDeliveryTime
      )
    def getLastFailureTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastFailureTime", lastFailureTime)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EnableLoggingResponse
  ) extends zio.aws.redshift.model.EnableLoggingResponse.ReadOnly {
    override val loggingEnabled: Option[Boolean] =
      scala.Option(impl.loggingEnabled()).map(value => value: Boolean)
    override val bucketName: Option[String] =
      scala.Option(impl.bucketName()).map(value => value: String)
    override val s3KeyPrefix: Option[String] =
      scala.Option(impl.s3KeyPrefix()).map(value => value: String)
    override val lastSuccessfulDeliveryTime: Option[TStamp] = scala
      .Option(impl.lastSuccessfulDeliveryTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val lastFailureTime: Option[TStamp] = scala
      .Option(impl.lastFailureTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val lastFailureMessage: Option[String] =
      scala.Option(impl.lastFailureMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EnableLoggingResponse
  ): zio.aws.redshift.model.EnableLoggingResponse.ReadOnly = new Wrapper(impl)
}
