package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClusterDbRevisionResponse(
    cluster: Option[zio.aws.redshift.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse = {
    import ModifyClusterDbRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterDbRevisionResponse.wrap(buildAwsValue())
}
object ModifyClusterDbRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterDbRevisionResponse =
      zio.aws.redshift.model
        .ModifyClusterDbRevisionResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse
  ) extends zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly {
    override val cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse
  ): zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly =
    new Wrapper(impl)
}
