package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteAuthenticationProfileResponse(
    authenticationProfileName: Option[AuthenticationProfileNameString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse = {
    import DeleteAuthenticationProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse
      .builder()
      .optionallyWith(
        authenticationProfileName.map(value =>
          AuthenticationProfileNameString.unwrap(value): java.lang.String
        )
      )(_.authenticationProfileName)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly =
    zio.aws.redshift.model.DeleteAuthenticationProfileResponse
      .wrap(buildAwsValue())
}
object DeleteAuthenticationProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteAuthenticationProfileResponse =
      zio.aws.redshift.model.DeleteAuthenticationProfileResponse(
        authenticationProfileName.map(value => value)
      )
    def authenticationProfileName: Option[AuthenticationProfileNameString]
    def getAuthenticationProfileName
        : ZIO[Any, AwsError, AuthenticationProfileNameString] = AwsError
      .unwrapOptionField("authenticationProfileName", authenticationProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse
  ) extends zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly {
    override val authenticationProfileName
        : Option[AuthenticationProfileNameString] = scala
      .Option(impl.authenticationProfileName())
      .map(value =>
        zio.aws.redshift.model.primitives.AuthenticationProfileNameString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse
  ): zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly =
    new Wrapper(impl)
}
