package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SupportedOperation(operationName: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SupportedOperation = {
    import SupportedOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SupportedOperation
      .builder()
      .optionallyWith(operationName.map(value => value: java.lang.String))(
        _.operationName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SupportedOperation.ReadOnly =
    zio.aws.redshift.model.SupportedOperation.wrap(buildAwsValue())
}
object SupportedOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SupportedOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SupportedOperation =
      zio.aws.redshift.model
        .SupportedOperation(operationName.map(value => value))
    def operationName: Option[String]
    def getOperationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationName", operationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SupportedOperation
  ) extends zio.aws.redshift.model.SupportedOperation.ReadOnly {
    override val operationName: Option[String] =
      scala.Option(impl.operationName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SupportedOperation
  ): zio.aws.redshift.model.SupportedOperation.ReadOnly = new Wrapper(impl)
}
